/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.boat;

import com.renyigesai.immortalers_delight.entities.boat.ImmortalersChestBoat;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AncientWoodChestBoat
extends ImmortalersChestBoat {
    private static final int CONTAINER_SIZE = 54;
    private static final EntityDataAccessor<Boolean> DATA_HAS_CANOPIES = SynchedEntityData.m_135353_(Creeper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private NonNullList<ItemStack> bigItemStacks = NonNullList.m_122780_((int)54, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;

    public AncientWoodChestBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public AncientWoodChestBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ImmortalersDelightEntities.ANCIENT_WOOD_CHEST_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HAS_CANOPIES, (Object)false);
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (((Boolean)this.f_19804_.m_135370_(DATA_HAS_CANOPIES)).booleanValue()) {
            compoundTag.m_128379_("HasCanopies", true);
        }
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DATA_HAS_CANOPIES, (Object)compoundTag.m_128471_("HasCanopies"));
    }

    public boolean hasCanopies() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_CANOPIES);
    }

    public void setCanopies(boolean canopies) {
        this.f_19804_.m_135381_(DATA_HAS_CANOPIES, (Object)canopies);
    }

    @Override
    public NonNullList<ItemStack> m_213659_() {
        return this.bigItemStacks;
    }

    @Override
    public int m_6643_() {
        return 54;
    }

    @Override
    public void m_213775_() {
        this.bigItemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        if (this.lootTable == null || !player.m_5833_()) {
            this.m_219913_(inventory.f_35978_);
            return ChestMenu.m_39246_((int)i, (Inventory)inventory, (Container)this);
        }
        return null;
    }

    @Override
    public void m_213560_(DamageSource damageSource) {
        this.m_19983_(new ItemStack((ItemLike)ImmortalersDelightItems.ANCIENT_WOOD_LOG.get(), 5));
        this.m_219927_(damageSource, this.m_9236_(), (Entity)this);
    }

    @Override
    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    @Override
    public void m_214199_(@Nullable ResourceLocation resourceLocation) {
        this.lootTable = resourceLocation;
    }

    public boolean m_271938_(Entity pEntity) {
        return pEntity.m_20205_() < 1.375f;
    }

    @Override
    protected float m_213802_() {
        return -1.45f;
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        super.m_19956_(pPassenger, pCallback);
        if (this.m_20363_(pPassenger)) {
            float f = this.m_213802_();
            float f1 = (float)((this.m_213877_() ? (double)0.01f : this.m_6048_()) + pPassenger.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(pPassenger);
                f = i == 0 ? 1.2f : -1.45f;
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            pCallback.m_20372_(pPassenger, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
        }
    }

    public double m_6048_() {
        return 0.15;
    }

    @Override
    protected int m_213801_() {
        return 2;
    }
}

